	dc = 0.01; ds = 0.001;
	[h, Err] = REMEZ_FIR(145, [0,0.3,1/3,1]*pi, [1,1,0,0], [1 dc/ds], 'm'); 
	wT = linspace(0,pi,1000);
	[H, wT] = freqz(h,1,wT); 	
	subplot(3,1,1),PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
	F = [0,4/16,1]; m = [0,1,0]; 				% Setting the inputs for fir2 
	x = fir2(255, F, m); 						% Input signal
	[X, wT] = freqz(x,1,wT); 					% Spectrum of the input signal
	subplot(3,1,2), PLOT_ABS_Z(wT, abs(X),'X')							
	u02 = DOWN_SAMPLE(x, 2);					% Down-sampling Lower input
	u1 = [0, x(1:end-1)]; 						% Upper: input + delay
	u12 = DOWN_SAMPLE(u1, 2);					% Down-sampling Upperinput
	x0 = 3*h(1:2:length(h));					% Polyphase decomposition,  Lower
	p00 = x0(1:3:end); 							% Lower paths branches in Figure 14.53
	p01 = x0(2:3:end); 		
	p02 = x0(3:3:end); 							 
	x1 = 3*h(2:2:length(h)); 					% Polyphase decomposition, Upper 	
	p10 = x1(1:3:end); 							% Upper paths branches in Figure 14.53	
	p11 = x1(1:3:end); 							
	p12 = x1(3:3:end);
	x00 = filter(p00,1,u02);					% Polyphase filtering Lower path 
	x01 = filter(p01,1,u02);	
	x02 = filter(p02,1,u02);
	x10 = filter(p10,1,u12);					% Polyphase filtering Upper path
	x11 = filter(p11,1,u12); 
	x12 = filter(p12,1,u12);					
	y0 = [x00; x01; x02];		
 	y0 = y0(:); 								% Commutator Lower path
	y0 = [0,(y0(1:end-1))']'; 					% Delay lower path
	y1 = [x10; x11; x12]; 	
	y1 = y1(:); 								% Commutator upper path
	y = y0 + y1; 								% Output signal 
	Y = (2/3)*freqz(y, 1, wT); 					% Scaling
	subplot(3,1,3), PLOT_ABS_Z(wT, abs(Y),'Y')	
	xlabel('{\it\omegaT} [rad]');
	
 
